﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Help.aspx.cs" Inherits="ccPublisherWeb.Help" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
   <title>Click2CAD Help</title>
   <link href="<%# ResolveUrl("~/StyleSheets/JavaHelp.css") %>" type="text/css" rel="stylesheet" />
   <ccPublisherWeb:JavascriptRessource ScriptName="PluginDetect.js" runat="server" />
</head>
<body id="JavaCheck">
   <form id="form1" runat="server">
      <asp:MultiView ID="LangSwitch" runat="server">
         <%-- BEGIN - de_DE --%>
         <asp:View ID="Lang_de_DE" runat="server">
            <h1 class="Title">CADClick<sup>&reg;</sup> Click2CAD-Systemvoraussetzungen</h1>
            <p>Um <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> verwenden zu k&ouml;nnen, muss Ihr System folgende Voraussetzungen erf&uuml;llen:</p>
   
            <ul>
               <li>Sie m&uuml;ssen einen Java-f&auml;higen Browser verwenden. Das <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> Applet wurde f&uuml;r den Gebrauch mit dem Internet-Explorer und Mozilla getestet.</li> 
               <li>Die Java-Unterst&uuml;tzung Ihres Browsers muss aktiviert sein.</li> 
               <li>Sie ben&ouml;tigen mindestens das Java <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">Plugin V<span class="LabelMinVersion"><%# ccPublisherWeb.ApplicationVars.Current["JavaMinRequiredVersion"] %></span></a> oder h&ouml;her.</li> 
            </ul>

            <div class="JavaDiv">
               <table border="0" cellspacing="0" cellpadding="5" width="100%">
                  <tr>
                     <td width="100%">
                        <table border="0" cellpadding="1" class="JavaCheck" cellspacing="0" height="25" width="100%" style="display: <%# StyleDisplay_JavaClientCheck %>">
                           <tr>
                              <td valign="middle" align="left" nowrap="nowrap">&nbsp;<img src="images/javaLogo.gif" />&nbsp;&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap"><b>Ihr Browser verwendet folgende Java-Umgebung:&nbsp;</b></td>
                              <td valign="middle" align="left" nowrap="nowrap" id="spinnerCell"><img width="16" height="16" src="images/spinner.gif" />&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap" width="100%"><span id="pInstalled" class="Java_OK">Suche Java Umgebung ...</span></td>
                           </tr>
                           <tr>
                              <td>&nbsp;</td>
                              <td colspan="3">
                                 <span id="javaCompNo" style="display: none;" class="Java_Fail">Diese Java-Version ist nicht kompatibel zu <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>. Sie k&ouml;nnen <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">hier</a> eine aktuelle Version herunterladen.</span>
                                 <span id="javaCompYes" style="display: none;" class="Java_Comp">Diese Java-Version kann mit <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> verwendet werden.</span>
                                 <span id="javaCompYesDisabled" style="display: none;" class="Java_Comp">Diese Java-Version kann mit <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> verwendet werden. <span class="Java_CompAlert">Allerdings m&uuml;ssen Sie Java in Ihrem Browser zuerst aktivieren!</span></span>
                                 <span id="javaNotFound" style="display: none;" class="Java_Fail">Es konnte keine Java-Umgebung gefunden werden. Sie k&ouml;nnen <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">hier</a> eine aktuelle Version herunterladen.</span>
                              </td>
                           </tr>
                        </table>

                        <p>Mit Hilfe unseres Test-Applets k&ouml;nnen Sie direkt &uuml;berpr&uuml;fen, ob Sie <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> auf Ihrem System
                        verwenden k&ouml;nnen. <b>Dazu m&uuml;ssen Sie die Sicherheitsabfrage beim Start des Test-Applets best&auml;tigen.</b></p>
               
                        <a id="ToggleHelp" href="javascript:;">Test-Applet Hilfe</a>
                        <div id="DetailHelp" style="display: none">
                           Sie m&uuml;ssen folgende Sicherheitsabfrage best&auml;tigen, andernfalls kann <span class="TM">CADClick<sup>&reg;</sup> </span> keine Daten an Ihre CAD-Software &uuml;bertragen:<br /><br />
                           <img alt="JavaCert" src="images/javaCert.gif" /><br />
                           <br />
                           <small><u>Hinweis:</u> Das Fenster kann - abh&auml;ngig vom Browser und der installierten Java-Version - anders aussehen als im Bild gezeigt.</small>
                           <br /><br />
                           Nach erfolgreicher Best&auml;tigung der Sicherheitsabfrage sollte folgendes Bild erscheinen:<br /><br />
                           <img alt="JavaApplet" src="images/JavaApplet.gif" />
                        </div>

                        <p style="clear: both; height: 5px"></p>

                        <table border="0" cellspacing="0" cellpadding="0">
                           <tr>
                              <td valign="middle"><img src="images/link.gif" /></td>
                              <td valign="middle" nowrap="nowrap"><a href="jre_check_cert.aspx">Test-Applet starten</a></td>
                           </tr>
                        </table>

                        <p>Bei diesem Test werden <b>keinerlei</b> Daten von Ihrem Rechner &uuml;bertragen oder gespeichert.</p> 
                     </td>
                  </tr>
               </table>
            </div>
   
            <br />
            <p>Sollten Sie eine aktuelle Java-Version ben&ouml;tigen, finden Sie hier die entsprechenden Downloadm&ouml;glichkeiten:</p> 
            <ul>
               <li>Betriebssysteme: Windows XP SP3, Windows Vista SP2, Windows 7, Windows 8.</li> 
               <li>Die aktuelle Java-Laufzeitumgebung (JRE) können Sie <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">hier</a> herunterladen.</li>
            </ul>
         </asp:View>
         <%-- END - de_DE --%>

         <%-- BEGIN - en_US --%>
         <asp:View ID="Lang_en_US" runat="server">
            <h1 class="Title">CADClick<sup>&reg;</sup> Click2CAD system requirements</h1>
            <p>To use <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>, your system must meet the following requirements:</p>
   
            <ul>
               <li>You must use a Java capable browser. The <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> applet has been tested for the use with the Internet-Explorer und Mozilla.</li> 
               <li>Java must be activated in your browser.</li> 
               <li>You need at least the Java <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">Plugin V<span class="LabelMinVersion"><%# ccPublisherWeb.ApplicationVars.Current["JavaMinRequiredVersion"] %></span></a> or higher.</li> 
            </ul>

            <div class="JavaDiv">
               <table border="0" cellspacing="0" cellpadding="5" width="100%">
                  <tr>
                     <td width="100%">
                        <table border="0" cellpadding="1" class="JavaCheck" cellspacing="0" height="25" width="100%" style="display: <%# StyleDisplay_JavaClientCheck %>">
                           <tr>
                              <td valign="middle" align="left" nowrap="nowrap">&nbsp;<img src="images/javaLogo.gif" />&nbsp;&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap"><b>Your browser uses the following Java environment:&nbsp;</b></td>
                              <td valign="middle" align="left" nowrap="nowrap" id="spinnerCell"><img width="16" height="16" src="images/spinner.gif" />&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap" width="100%"><span id="pInstalled" class="Java_OK">searching for Java environment...</span></td>
                           </tr>
                           <tr>
                              <td>&nbsp;</td>
                              <td colspan="3">
                                 <span id="javaCompNo" style="display: none;" class="Java_Fail">This Java version is not compatible to<span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>. You can download a current version <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">here</a>.</span>
                                 <span id="javaCompYes" style="display: none;" class="Java_Comp">This Java version can be used with <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>.</span>
                                 <span id="javaCompYesDisabled" style="display: none;" class="Java_Comp">This Java version can be used with <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>.<span class="Java_CompAlert">However you must first activate Java in your browser!</span></span>
                                 <span id="javaNotFound" style="display: none;" class="Java_Fail">No Java environment has been found. You can download a current version <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">here</a>.</span>
                              </td>
                           </tr>
                        </table>

                        <p>With our test applet, you can immediately check if <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> can be used on your
                        system. <b>For this purpose, you must confirm the security question when the test applet starts .</b></p>
               
                        <a id="ToggleHelp" href="javascript:;">Test applet help</a>
                        <div id="DetailHelp" style="display: none">
                           You must approve this security question, otherwise <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> can not transfer any Data to your CAD-Software:<br /><br />
                           <img alt="JavaCert" src="images/javaCert.gif" /><br />
                           <br />
                           <small><u>Indication:</u> the window can - depending on the browser and the installed Java version - look different than the shown image.</small>
                           <br /><br />
                           After the confirmation of the security question, following image should be shown:<br /><br />
                           <img alt="JavaApplet" src="images/JavaApplet.gif" />
                        </div>

                        <p style="clear: both; height: 5px"></p>

                        <table border="0" cellspacing="0" cellpadding="0">
                           <tr>
                              <td valign="middle"><img alt="link" src="images/link.gif" /></td>
                              <td valign="middle" nowrap="nowrap"><a href="jre_check_cert.aspx">Start the test applet</a></td>
                           </tr>
                        </table>

                        <p>During this test, <b>no</b> data are been transferred from your computer nor saved.</p> 
                     </td>
                  </tr>
               </table>
            </div>
   
            <br />
            <p>Should you need a current Java version, the corresponding download possibilities are shown here:</p> 
            <ul>
               <li>Operating systems: Windows XP SP3, Windows Vista SP2, Windows 7, Windows 8.</li> 
               <li>The current Java Runtime Environment (JRE) can be downloaded <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">here</a>.</li>
            </ul>
         </asp:View>
         <%-- END - en_US --%>

         <%-- BEGIN - fr_FR --%>
         <asp:View ID="Lang_fr_FR" runat="server">
            <h1 class="Title">Configuration système requise pour CADClick<sup>&reg;</sup> Click2CAD</h1>
            <p> Afin de pouvoir utiliser <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>, votre configuration 
                système doit satisfaire les points suivants:</p>
   
            <ul>
               <li>Votre navigateur Internet doit supporter Java. L'applet <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> 
                   a été testé pour l&#39;utilisation avec Internet Explorer et Mozilla.</li> 
               <li>Java doit &ecirc;tre activ&eacute; dans votre navigateur.</li> 
               <li>Vous avez besoin au moins du Java <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">Plugin V<span class="LabelMinVersion"><%# ccPublisherWeb.ApplicationVars.Current["JavaMinRequiredVersion"] %></span></a> 
                   ou d&#39;une version supérieure.</li> 
            </ul>

            <div class="JavaDiv">
               <table border="0" cellspacing="0" cellpadding="5" width="100%">
                  <tr>
                     <td width="100%">
                        <table border="0" cellpadding="1" class="JavaCheck" cellspacing="0" height="25" width="100%" style="display: <%# StyleDisplay_JavaClientCheck %>">
                           <tr>
                              <td valign="middle" align="left" nowrap="nowrap">&nbsp;<img src="images/javaLogo.gif" />&nbsp;&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap"><b>Votre navigateur utilise l'environnement Java suivant:&nbsp;</b></td>
                              <td valign="middle" align="left" nowrap="nowrap" id="spinnerCell"><img width="16" height="16" src="images/spinner.gif" />&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap" width="100%"><span id="pInstalled" class="Java_OK">Recherche de l'environnement Java...</span></td>
                           </tr>
                           <tr>
                              <td>&nbsp;</td>
                              <td colspan="3">
                                 <span id="javaCompNo" style="display: none;" class="Java_Fail">Cette version de Java n'est pas compatible avec <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>. Vous pouvez t&eacute;l&eacute;charger une version actuelle <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">ici</a>.</span>
                                 <span id="javaCompYes" style="display: none;" class="Java_Comp">Cette version de Java peut &ecirc;tre utilis&eacute;e avec <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>.</span>
                                 <span id="javaCompYesDisabled" style="display: none;" class="Java_Comp">Cette version de Java peut &ecirc;tre utilis&eacute;e avec<span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>. <span class="Java_CompAlert">Vous devez cependant activer Java dans votre navigateur!</span></span>
                                 <span id="javaNotFound" style="display: none;" class="Java_Fail">Aucun environnement Java a &eacute;t&eacute; trouv&eacute;. Vous pouvez t&eacute;l&eacute;charger une version actuelle <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">ici</a>.</span>
                              </td>
                           </tr>
                        </table>

                        <p>
                           Grâce à notre applet test, vous pouvez immédiatement tester si vous pouvez 
                           utiliser <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> sur votre
                           ordinateur. <b>A ce sujet, vous devez confirmer la question de sécurité lors du démarrage de l'applet test.</b>
                         </p>
               
                        <a id="ToggleHelp" href="javascript:;">Test applet help</a>
                        <div id="DetailHelp" style="display: none">
                           Vous devez confirmer la question de s&eacute;curit&eacute; suivante, faute de quoi <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> ne peut pas transf&eacute;rer des donn&eacute;es vers votre logiciel de CAO:<br /><br />
                           <img alt="JavaCert" src="images/javaCert.gif" /><br />
                           <br />
                           <small><u>Indication:</u> La fen&ecirc; peut - d&eacute;pendant du navigateur et de la version de Java install&eacute;e  - avoir une apparence diff&eacute;rente de celle de l'image montr&eacute;e.</small>
                           <br /><br />
                           Si la confirmation de la question de s&eacute; est r&eacute;alis&eacute;, l'image suivant devrait appara&icirc;tre:<br /><br />
                           <img alt="JavaApplet" src="images/JavaApplet.gif" />
                        </div>

                        <p style="clear: both; height: 5px"></p>

                        <table border="0" cellspacing="0" cellpadding="0">
                           <tr>
                              <td valign="middle"><img src="images/link.gif" /></td>
                              <td valign="middle" nowrap="nowrap"><a href="jre_check_cert.aspx">Démarrer l'applet test</a></td>
                           </tr>
                        </table>

                        <p>Lors de ce test, <b>aucunes</b> donn&eacute;es ne sont transf&eacute;r&eacute;es de votre ordinateur ni 
                            sauvegard&eacute;es.</p> 
                     </td>
                  </tr>
               </table>
            </div>
   
            <br />
            <p>Si vous avez besoin d'une version actuelle de Java, vous trouverez ici les possibilit&eacute;s de t&eacute;l&eacute;chargement correspondantes:</p> 
            <ul>
               <li>Systèmes d'exploitation: Windows XP SP3, Windows Vista SP2, Windows 7, Windows 8.</li> 
               <li>Vous pouvez télécharger le Java JRE (Java Runtime Environment) actuel <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">ici</a>.</li>
            </ul>
         </asp:View>
         <%-- END - fr_FR --%>

         <%-- BEGIN - pl_PL --%>
         <asp:View ID="Lang_pl_PL" runat="server">
            <h1 class="Title">CADClick<sup>&reg;</sup> Click2CAD-wymagania systemowe</h1>
            <p>Aby użyć <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> system musi spełnić następujące wymagania:</p>

            <ul>
               <li>Musisz używać współpracującej z Java przeglądarki. Aplikacja <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> jest testowana dla przeglądarek Internet Explorer i Mozilla.</li>
               <li>Wsparcie Java musi być aktywne dla twojej przeglądarki.</li> 
			   <li>Potrzebujesz przynajmniej Java <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">Plugin V<span class="LabelMinVersion"><%# ccPublisherWeb.ApplicationVars.Current["JavaMinRequiredVersion"] %></span></a> lub wyższej wersji.</li>
            </ul>
   
            <div class="JavaDiv">
               <table border="0" cellspacing="0" cellpadding="5" width="100%">
                  <tr>
                     <td width="100%">
                        <table border="0" cellpadding="1" class="JavaCheck" cellspacing="0" height="25" width="100%" style="display: <%# StyleDisplay_JavaClientCheck %>">
                           <tr>
                              <td valign="middle" align="left" nowrap="nowrap">&nbsp;<img src="images/javaLogo.gif" />&nbsp;&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap"><b>Przeglądarka używa otoczenia Java:&nbsp;</b></td>
                              <td valign="middle" align="left" nowrap="nowrap" id="spinnerCell"><img width="16" height="16" src="images/spinner.gif" />&nbsp;</td>
                              <td valign="middle" align="left" nowrap="nowrap" width="100%"><span id="pInstalled" class="Java_OK">Szukaj środowisko Java...</span></td>
                           </tr>
                           <tr>
                              <td>&nbsp;</td>
                              <td colspan="3">
                                 <span id="javaCompNo" style="display: none;" class="Java_Fail">Ta wersja Java nie jest zgodny z <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>. Możesz pobrać <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">aktualną wersję</a>.</span>
                                 <span id="javaCompYes" style="display: none;" class="Java_Comp">Ta wersja może być użyta dla <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>.</span>
                                 <span id="javaCompYesDisabled" style="display: none;" class="Java_Comp">Ta wersja Java może być używany z <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span>. <span class="Java_CompAlert">Jednak musisz mieć Java włączone w Twojej przeglądarce pierwszy!</span></span>
                                 <span id="javaNotFound" style="display: none;" class="Java_Fail">Nie można znaleźć środowiska Java. Możesz pobrać <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">aktualną wersję</a>.</span>
                              </td>
                           </tr>
                        </table>

						<p>Z pomocą naszej testowej aplikacji możesz sprawdzić , czy możesz użyć <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> w systemie. <b>Do tego musisz potwierdzić pytanie bezpieczeństwa aplikacji testowej.</b></p>
               
                        <a id="ToggleHelp" href="javascript:;">Pomoc Aplikacja test</a>
                        <div id="DetailHelp" style="display: none">
                           Musisz zgodzić się następujący monit, w przeciwnym razie <span class="TM">CADClick<sup>&reg;</sup> Click2CAD</span> nie przesyłać dane do aplikacji CAD:<br /><br />
                           <img alt="JavaCert" src="images/javaCert.gif" /><br />
                           <br />
                           <small><u>Uwaga:</u>&nbsp;okno może być - w zależności od przeglądarki i wersji Java zainstalowana - wyglądać inaczej niż pokazany na zdjęciu.</small>
                           <br /><br />
                           Po udanym potwierdzeniu kwestii bezpieczeństwa powinien pojawić się następujący obrazek:<br /><br />
                           <img alt="JavaApplet" src="images/JavaApplet.gif" />
                        </div>

                        <p style="clear: both; height: 5px"></p>

                        <table border="0" cellspacing="0" cellpadding="0">
                           <tr>
                              <td valign="middle"><img src="images/link.gif" /></td>
                              <td valign="middle" nowrap="nowrap"><a href="jre_check_cert.aspx">Rozpocznij aplikację test</a></td>
                           </tr>
                        </table>

                        <p>W tym teście nie zostaną przekazane ani zapisane <b>żadne</b> dane z twojego komputera.</p> 
                     </td>
                  </tr>
               </table>
            </div>
   
            <br />
            <p>Potrzebujesz aktualnej wersji Java:</p> 
            <ul>
               <li>Systemy operacyjne: Windows XP SP3, Windows Vista SP2, Windows 7, Windows 8.</li>
			   <li>Aktualne otoczenie Java (JRE) możesz importować <a href="javascript:;" onclick="window.open('<%# ccPublisherWeb.ApplicationVars.Current["JavaJREDownloadURL"] %>')">tutaj</a></li>
            </ul>
         </asp:View>
         <%-- END - pl_PL --%>
      </asp:MultiView>

      <script language="javascript" type="text/javascript">
         // Dummy statement that forces java detection to begin
         PluginDetect.onDetectionDone("Java", 0);

         function checkJava(pluginDetect) {
            var javaVersion = pluginDetect.getVersion("Java");
            var javaStatus  = pluginDetect.isMinVersion("Java", "<%# ccPublisherWeb.ApplicationVars.Current["JavaMinRequiredVersion"] %>");
            var javaEnabled = (javaStatus == 1) ? true : false;

            $("#spinnerCell").hide();
         
            if(javaVersion) {
               javaVersion = javaVersion.replace(/,/g, '.');
               $("#pInstalled").html(javaVersion);

               switch(javaStatus) {
                  case -1:
                     $("#javaCompNo").show();
                     break;
                  
                  case -0.2:
                     $("#javaCompYesDisabled").show();
                     break;
                  
                  case 1:
                     $("#javaCompYes").show();
                     break;
               }
            } else {
               $("#javaNotFound").show();
            }
         };

         $(function() {
            if(<%# CommonFunc.JsBool(checkJava) %>) {
               PluginDetect.onDetectionDone("Java", checkJava, "getJavaInfo.jar", null);
            }

            $("#ToggleHelp").click(function() {
               var vis = $("#DetailHelp").is(":visible");

               $(this).toggleClass("open", !vis);

               if(vis) {
                  $("#DetailHelp").hide();
               } else {
                  $("#DetailHelp").show();
               }
            });
         });
      </script>
   </form>
</body>
</html>
